{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 * Data inici: 02/12/1997
 * Ultim dia:  06/01/1998
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitTools;

{******************************************************}
interface
{******************************************************}

uses Windows, SysUtils;

procedure CopiarFinestraALaCarpeta(HWindow: HWnd);
procedure CopiarPartDeLaFinestraALaCarpeta(HWindow: HWnd;Rect:TRect);
//procedure PrintBitMap(HWindow: HWnd);

function Max(i1,i2:LongInt):LongInt;
function Min(i1,i2:LongInt):LongInt;
function PotDe2(exponent:integer):integer;

Function Arrodonir(V:Real):Longint;
Function RealToString(V:Real):String;
function TornarNota(Frequencia:real):string;
Function TornarFrequenciaNotaMusical(Frequencia:real):single;
{******************************************************}
implementation
{******************************************************}

procedure CopiarFinestraALaCarpeta(HWindow: HWnd);
Var
  ThDC: HDC;
  hdcmem: HDC;
  GHBitmap: THandle;
  sa,sb: string;
  Dx,Dy,fxi,fxf,fyi,fyf: integer;
  Texte: array[0..255] of char;
  Comodi: array[0..255] of char;
  Rect:TRect;     {mesures del rectangle a pintar}

  procedure MissatgeError(ErrorMissatge:PChar);
  var
    texte2: array[0..10] of char;
  begin
    LoadString(HInstance,1,Texte2,SizeOf(Texte2));
    MessageBox(HWindow,ErrorMissatge,texte2, mb_Ok or mb_IconStop);
  end;

begin
  GetClientRect(HWindow,Rect);
  fxi:=Rect.left; fxf:=Rect.right;
  fyi:=Rect.top; fyf:=Rect.bottom;
  Dx:=fxf-fxi; Dy:=fyf-fyi;
  ThDC := GetDC(HWindow);
  hdcMem := CreateCompatibleDC(ThDC);
  GHBitmap := CreateCompatibleBitmap(ThDC,Dx,Dy);
  if GhBitmap<>0 then begin
    SelectObject(hdcMem, GhBitmap);
    StretchBlt(hdcMem, 0, 0, Dx, Dy,ThDC,0,0,Dx,Dy,SrcCopy);
    if OpenClipboard(HWindow) then begin
      EmptyClipboard;
      SetClipboardData(CF_BITMAP, GhBitmap) ;
      CloseClipboard;
    end else begin
      LoadString(HInstance,4,Texte,SizeOf(Texte));
      sa:=StrPas(Texte);
      sa:=sa+#13#10+#13#10;
      LoadString(HInstance,5,Texte,SizeOf(Texte));
      sb:=StrPas(Texte);
      sa:=sa+sb;
      StrPCopy(Comodi,sa);
      MissatgeError(Comodi);
    end;
  end else begin
    LoadString(HInstance,6,Texte,SizeOf(Texte));
    sa:=StrPas(Texte);
    sa:=sa+#13#10+#13#10;
    LoadString(HInstance,7,Texte,SizeOf(Texte));
    sb:=StrPas(Texte);
    sa:=sa+sb;
    StrPCopy(Comodi,sa);
    MissatgeError(Comodi);
  end;
  DeleteDC(hdcMem);
  ReleaseDC(HWindow,ThDC);
end;

procedure CopiarPartDeLaFinestraALaCarpeta(HWindow: HWnd;Rect:TRect);
Var
  ThDC: HDC;
  hdcmem: HDC;
  GHBitmap: THandle;
  sa,sb: string;
  Dx,Dy,fxi,fxf,fyi,fyf: integer;
  Texte: array[0..255] of char;
  Comodi: array[0..255] of char;

  procedure MissatgeError(ErrorMissatge:PChar);
  var
    texte2: array[0..10] of char;
  begin
    LoadString(HInstance,1,Texte2,SizeOf(Texte2));
    MessageBox(HWindow,ErrorMissatge,texte2, mb_Ok or mb_IconStop);
  end;

begin
  fxi:=Rect.left; fxf:=Rect.right;
  fyi:=Rect.top; fyf:=Rect.bottom;
  Dx:=fxf-fxi; Dy:=fyf-fyi;
  ThDC := GetDC(HWindow);
  hdcMem := CreateCompatibleDC(ThDC);
  GHBitmap := CreateCompatibleBitmap(ThDC,Dx,Dy);
  if GhBitmap<>0 then begin
    SelectObject(hdcMem, GhBitmap);
    StretchBlt(hdcMem, 0,0,Dx,Dy,ThDC,Rect.left, Rect.top, Dx, Dy,SrcCopy);
    if OpenClipboard(HWindow) then begin
      EmptyClipboard;
      SetClipboardData(CF_BITMAP, GhBitmap) ;
      CloseClipboard;
    end else begin
      LoadString(HInstance,4,Texte,SizeOf(Texte));
      sa:=StrPas(Texte);
      sa:=sa+#13#10+#13#10;
      LoadString(HInstance,5,Texte,SizeOf(Texte));
      sb:=StrPas(Texte);
      sa:=sa+sb;
      StrPCopy(Comodi,sa);
      MissatgeError(Comodi);
    end;
  end else begin
    LoadString(HInstance,6,Texte,SizeOf(Texte));
    sa:=StrPas(Texte);
    sa:=sa+#13#10+#13#10;
    LoadString(HInstance,7,Texte,SizeOf(Texte));
    sb:=StrPas(Texte);
    sa:=sa+sb;
    StrPCopy(Comodi,sa);
    MissatgeError(Comodi);
  end;
  DeleteDC(hdcMem);
  ReleaseDC(HWindow,ThDC);
end;
{
procedure PrintBitMap(HWindow: HWnd);
var
  DC, ScreenDC, MemDC: HDC;
  BM: TBitMap;
  R:TRect;
  BitMap,OldBitMap: HBitMap;
  Driver, PrintDevice, Port: array[0..40] of Char;
  S: array[0..10] of Char;
  DCaps: Word;
  PHr, DHr:integer;
  h,v:integer;

  procedure GetIniInfo(ADriver, ADevice, Port: PChar);
  var
    PrinterString: array[0..80] of char;
    Device, Driver, OutPut: PChar;
  begin
    GetProfileString('Windows', 'Device', ',,,', PrinterString, 80);
    Device := PrinterString;
    Driver := StrScan(Device, ',');
    Driver[0] := #0;
    Inc(Driver);
    OutPut := StrScan(Driver, ',');
    OutPut[0] := #0;
    Inc(OutPut);
    StrCopy(Port, OutPut);
    StrCopy(ADevice, Device);
    StrCopy(ADriver, Driver);
  end;

begin
  SetCursor(LoadCursor(0, idc_Wait));
  GetClientRect(HWindow,R);
  GetIniInfo(Driver, PrintDevice, Port);
  DC := CreateDC(Driver, PrintDevice, Port, Nil);
  StrCopy(S,'HardCopy'#0);
  //Escape(DC, STARTDOC, 8, @S, nil);
  //STARTDOC(DC,@S);
  ScreenDC := GetDC(HWindow);
  MemDC := CreateCompatibleDC(ScreenDC);
  BitMap := CreateCompatibleBitmap(ScreenDC,R.right-R.left,R.bottom-R.top);
  OldBitMap := SelectObject(MemDC, BitMap);
  BitBlt(MemDC, 0, 0,R.right-R.left,R.bottom-R.top,ScreenDC,0,0,SRCCOPY);
  PHr:=GetDeviceCaps(DC,HORZRES);
  DHr:=GetDeviceCaps(ScreenDC,HORZRES);
  h:=round((R.right-R.left)/Dhr*Phr);
  v:=round((R.bottom-R.top)/Dhr*Phr);
  StretchBlt(DC, 0, 0, h, v,MemDC,0,0,R.right-R.left,R.bottom-R.top,SrcCopy);
  Escape(DC, NEWFRAME, 0, nil, nil);
  //Escape(DC, ENDDOC, 0, nil, nil);
  ENDDOC(DC);
  SelectObject(MemDC, OldBitMap);
  DeleteDC(MemDC);
  ReleaseDC(HWindow, ScreenDC);
  DeleteDC(DC);
  SetCursor(LoadCursor(0, idc_Arrow));
end;
}
{******************************************************}
function Max(i1,i2:LongInt):LongInt;
begin
  if i2>i1 then Max:=i2 else Max:=i1;
end;

function Min(i1,i2:LongInt):LongInt;
begin
  if i2<i1 then Min:=i2 else Min:=i1;
end;

function PotDe2(exponent:integer):integer;
var
  i,c:integer;
begin
  if exponent=0 then begin
    c:=1;
  end else begin
    c:=1;
    for i:=1 to exponent do c:=c*2;
  end;
  PotDe2:=c;
end;

Function Arrodonir(V:Real):Longint;
begin
  if v>2000000000 then begin
    Arrodonir:=2000000000;
  end else if v<-2000000000 then begin
    Arrodonir:=-2000000000;
  end else begin
    Arrodonir:=Round(v);
  end;
end;

Function RealToString(V:Real):String;
var
  s:string;
  d,i,n:integer;
  sco:string;
begin
  if v>100000 then v:=int(v);
  if V=Arrodonir(V) then begin
    Str(V:1:0,s);
    RealToString:= s;
  end else begin
    Str(V:1:6,s);
    d:=length(s);
    for i:=d downto d-6 do begin
      sco:=Copy(s,i,1);
      if sco<>'0' then begin
        n:=i;
        if Copy(s,n,1)='.' then n:=n-1;
        sco:=Copy(s,1,n);
        RealToString:=sco;
        break;
      end;
    end;
  end;
end;

const
  Notes:array[0..11] of PChar = ('Si','Do','Do#','Re','Re#','Mi','Fa','Fa#','Sol','Sol#','La','La#');

Function TornarFrequenciaNotaMusical(Frequencia:real):single;
var
  n:integer;
  r12d2,DoInicial:real;
label
  LabelFor1;
begin
  r12d2 := exp(1/12*ln(2));
  DoInicial:=440/exp(45*ln(r12d2));
  n:=0;
  while n<=84 do begin
    inc(n);
  {for n:=1 to 84 do begin}
    if Frequencia<DoInicial then begin
      if n>1 then begin
        if DoInicial/sqrt(r12d2)>Frequencia then begin
          n:=n-1;
          DoInicial:=DoInicial/r12d2;
        end;
      end;
      GoTo LabelFor1;
    end;
    DoInicial:=DoInicial*r12d2;
  end;
LabelFor1:
  TornarFrequenciaNotaMusical:=round(100*DoInicial)/100;
end;

Function TornarNota(Frequencia:real):string;
var
  n:integer;
  r12d2,DoInicial:real;
label
  LabelFor1;
begin
  r12d2 := exp(1/12*ln(2));
  DoInicial:=440/exp(45*ln(r12d2));
  n:=0;
  while n<=84 do begin
    inc(n);
  {for n:=1 to 84 do begin}
    if Frequencia<DoInicial then begin
      if n>1 then begin
        if DoInicial/sqrt(r12d2)>Frequencia then begin
          n:=n-1;
          DoInicial:=DoInicial/r12d2;
        end;
      end;
      GoTo LabelFor1;
    end;
    DoInicial:=DoInicial*r12d2;
  end;
LabelFor1:
  if Notes[n mod 12]='Si' then begin
    TornarNota:=StrPas(Notes[n mod 12])+RealToString((n-1) Div 12)+': '+RealToString(round(100*DoInicial)/100)+' Hz.';
  end else begin
    TornarNota:=StrPas(Notes[n mod 12])+RealToString(n Div 12)+': '+RealToString(round(100*DoInicial)/100)+' Hz.';
  end;
end;

{******************************************************}
end.
